clear
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Bailout_2016/data_20160808.dta"

reg beta_log_fwd      bhck7204_inv
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd_up   bhck7204_inv
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd_down bhck7204_inv
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd      bhck7204_inv, noconstant
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd_up   bhck7204_inv, noconstant
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd_down bhck7204_inv, noconstant
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

*** Figure
lpoly beta_log_fwd bhck7204_inv, noscatter width(0.1) n(20) title("") ytitle("Actual Beta") xtitle("Leverage") lineopts(lpattern(dash) lcolor(black)) graphregion(fcolor(white) style(none)) yscale(range(0 3)) xscale(range(0 25)) ylabel(0(0.5)3) xlabel(0(5)25) note("") plotregion(style(none))
graph export BW.png, replace
graph export wf_figure.png, replace

*** Larry says can we redo this with year-month fixed effects 

gen year_string = string(year) 
gen month_string = string(month) 
gen year_month = year_string+month_string 

**** now we need to set up the panel 
egen year_month_num = group(year_month) 

reg beta_log_fwd  bhck7204_inv i.year_month_num
outreg2 bhck7204_inv using wf_table_3.txt, append bracket adjr2
reg beta_log_fwd_up   bhck7204_inv i.year_month_num 
outreg2 bhck7204_inv using wf_table_3.txt, append bracket adjr2
reg beta_log_fwd_down bhck7204_inv i.year_month_num 
outreg2 bhck7204_inv using wf_table_3.txt, append bracket adjr2

**** or let's just try to do it year-month combo 

by year_month_num, sort: reg beta_log_fwd bhck7204_inv

*** need to understand what these dummies are doing, so need to read Petersen paper 

*** we want to do this same excercise for risk-weighted assets and non risk-weighted 
*** match with mve data on yr mo, permno 
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/full_vars_mve_riskassets_09052016.dta", clear
*** our risk assets data is quarterly, we'll have to throw out some of the BW data. 

*** note we have monthly changes in rf rate in our MVE/assets 
*** create year month var 
gen month = month(date)
tostring year, gen(year_string)
tostring month, gen(month_string)
*** add in an extra integer to month if single digits 
replace month_string = "01" if month_string == "1" 
replace month_string = "02" if month_string == "2" 
replace month_string = "03" if month_string == "3" 
replace month_string = "04" if month_string == "4" 
replace month_string = "05" if month_string == "5" 
replace month_string = "06" if month_string == "6" 
replace month_string = "07" if month_string == "7" 
replace month_string = "08" if month_string == "8" 
replace month_string = "09" if month_string == "9" 
gen yrmo_string=year_string+month_string
destring yrmo_string, gen(yrmo) 

*** add in permnos
gen permno = . 
replace permno = 14558 if name == "ally"
replace permno = 59176 if name == "am"
replace permno = 15318 if name == "abb" 
replace permno = 71563 if name == "bbnt" 
replace permno = 76892 if name == "bok"
replace permno = 49656 if name == "bnyc" 
replace permno = 59408 if name == "baml"
replace permno = 84003 if name == "bank"
replace permno = 89463 if name == "cit" & year < 2010 
replace permno = 93150 if name == "cit" & year >= 2010 
replace permno = 81055 if name == "cap"
replace permno = 47896 if name == "jpm"
replace permno  = 70519 if name == "citi"
replace permno = 14889 if name == "citizens"
replace permno = 25081 if name == "comerica"
replace permno = 27888 if name == "cullen"
replace permno = 25129 if name == "bancshares"
replace permno = 92121 if name == "discover"
replace permno = 83862 if name == "e"
replace permno = 86719 if name == "eastwest"
replace permno =13384 if name == "everbank"
replace permno = 34746 if name == "fifththird"
replace permno = 10777 if name == "firstcitizen"
replace permno = 36397 if name == "firsthorizon"
replace permno = 35167 if name == "firstmerit"
replace permno = 85994 if name == "firstniagra"
replace permno = 88343 if name == "pacwest"
replace permno = 35554 if name == "m"
replace permno = 86868 if name == "gs"
replace permno = 76684 if name == "hancock"
replace permno = 42906 if name == "huntington"
replace permno = 81564 if name == "iberia"
replace permno = 90952 if name == "investors"
replace permno = 47896 if name == "jpm"
replace permno = 64995 if name == "keycorp"
replace permno = 69032 if name == "ms"
replace permno = 79859 if name == "newyork"
replace permno = 58246 if name == "northern"
replace permno = 60442 if name == "pnc"
replace permno = 38703 if name == "wf"
replace permno = 12073 if name == "peoples"
replace permno = 86432 if name == "prosperity"
replace permno = 69649 if name == "raymond"
replace permno = 35044 if name == "regions"
replace permno = 11786 if name == "svb"
replace permno = 75186 if name == "schwab"
replace permno = 86004 if name == "umpqua"
replace permno = 72726 if name == "statestreet"
replace permno = 68144 if name == "suntrust"
replace permno = 14776 if name == "synchrony"
replace permno = 20053 if name == "synovus"
replace permno = 10375 if name == "tcf"
replace permno = 66157 if name == "banccorp"
replace permno = 84129 if name == "zions"
replace permno = 84636 if name == "wintrust"
replace permno = 10932 if name == "webster"
replace permno = 80072 if name == "valley"

drop _merge
drop output_indicator 
**** we need monthly averages, not clear this is the right thing to do because assets is a quarterly measure. 
by permno yrmo, sort: egen mean_mve_div_assets=mean(mve_div_assets)
by permno yrmo, sort: egen mean_mve_div_risk=mean(mve_div_risk)
by permno yrmo, sort: gen output_indicator = _n 
keep if output_indicator == 1 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/bw_mve.dta", replace


use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Bailout_2016/data_20160808.dta", clear
drop _merge 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Bailout_2016/data_2016926.dta", replace

merge 1:1 permno yrmo using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/bw_mve.dta"

drop if _merge == 2 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/bw_mve.dta", replace

cd "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/Tables"

use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/bw_mve.dta", clear

**** we have some crazy outliers we need to get rid of 
*drop if (mean_mve_div_risk>4 & mean_mve_div_risk != .)

winsor2 mean_mve_div_risk, replace cuts(1 99)
winsor2 mean_mve_div_assets, replace cuts(1 99)

reg mean_mve_div_assets      bhck7204_inv
outreg2 bhck7204_inv using bw_mve_final.txt, replace

reg mean_mve_div_risk   bhck7204_inv
outreg2 bhck7204_inv using bw_mve_risk_final.txt, replace

br bhck7204_inv mean_mve_div_assets mean_mve_div_risk if bhck7204_inv <10 

/*reg beta_log_fwd_down bhck7204_inv
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd      bhck7204_inv, noconstant
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd_up   bhck7204_inv, noconstant
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2

reg beta_log_fwd_down bhck7204_inv, noconstant
outreg2 bhck7204_inv using wf_table_2.txt, append bracket adjr2*/

*** Figure
lpoly mean_mve_div_assets bhck7204_inv, noscatter width(0.1) n(20) title("") ytitle("MVE/Assets") xtitle("Leverage") lineopts(lpattern(dash) lcolor(black)) graphregion(fcolor(white) style(none)) yscale(range(0 .5)) xscale(range(0 25)) ylabel(0(0.1).5) xlabel(0(5)25) note("") plotregion(style(none))
graph export bw_mve.png, replace

lpoly mean_mve_div_risk bhck7204_inv, noscatter width(0.1) n(20) title("") ytitle("MVE/Risk-Adjusted Assets") xtitle("Leverage") lineopts(lpattern(dash) lcolor(black)) graphregion(fcolor(white) style(none)) yscale(range(0 .8)) xscale(range(0 25)) ylabel(0(0.1).8) xlabel(0(5)25) note("") plotregion(style(none))
graph export bw_mve_risk.png, replace
